CREATE DATABASE IF NOT EXISTS db_popjasa;
USE db_popjasa;

-- Tabel Admin
CREATE TABLE IF NOT EXISTS `admin` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `admin` (`username`, `password`, `nama_lengkap`) VALUES 
('admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator POPJASA');

-- Tabel Artikel
CREATE TABLE IF NOT EXISTS `articles` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `articles` (`title`) VALUES 
('PENTINGNYA AKTA NOTARIS'), ('MANFAAT NPWP BADAN'), ('SYARAT OSS RBA'), 
('IZIN EDAR BPOM'), ('LEGALITAS CV TERBARU'), ('TIPS PAJAK UMKM'), 
('CARA DAFTAR MEREK HAKI'), ('PANDUAN PENDIRIAN PT 2026');

-- Tabel Pin Artikel Home
CREATE TABLE IF NOT EXISTS `home_pinned_articles` (
  `slot` int(11) PRIMARY KEY,
  `article_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_pinned_articles` (`slot`, `article_id`) VALUES (1, 8), (2, 7), (3, 6);

-- Tabel Slider Chat
CREATE TABLE IF NOT EXISTS `home_chat_slides` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_chat_slides` (`image`, `label`) VALUES 
('chat1.jpg', 'Testimoni Client Surabaya #1'), ('chat2.jpg', 'Testimoni Client Surabaya #2'),
('chat3.jpg', 'Testimoni Izin PT Malang'), ('chat4.jpg', 'Klien PIRT Gresik'), ('chat5.jpg', 'NIB Express Jakarta');

-- Tabel Trusted Partners
CREATE TABLE IF NOT EXISTS `home_partners` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_partners` (`image`, `label`) VALUES 
('oss.png', 'PT. MAJU BERSAMA JASA'), ('kemenkumham.png', 'INSTANSI KEMENKUMHAM'), 
('pajak.png', 'DITJEN PAJAK RI'), ('bpom.png', 'BPOM INDONESIA'), ('mui.png', 'MUI HALAL');

-- Tabel FAQ
CREATE TABLE IF NOT EXISTS `home_faq` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `question` text NOT NULL,
  `answer` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_faq` (`question`, `answer`) VALUES 
('Berapa lama proses pembuatan PT?', 'Proses pengerjaan sekitar 7-10 hari kerja setelah dokumen lengkap.'),
('Apakah melayani seluruh Indonesia?', 'Ya, kami memiliki 9 cabang dan melayani secara nasional.'),
('Apa syarat buat CV?', 'Cukup KTP, KK, dan NPWP para pendiri.'),
('Bagaimana sistem bayarnya?', 'Bisa melalui transfer bank resmi perusahaan.'),
('Apakah harga sudah termasuk pajak?', 'Ya, harga yang tertera sudah all-in.');