<?php
session_start();
include '../config/database.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// Data dummy untuk dashboard
$stats = [
    'klien' => 5,
    'artikel' => 7,
    'layanan' => 16,
    'testimoni' => 5
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - POPJASA ADMIN PANEL</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f4f7fe; }
        .sidebar { background-color: #212529; transition: all 0.3s; width: 280px; }
        .nav-link { color: #adb5bd; transition: all 0.2s; border-left: 4px solid transparent; cursor: pointer; }
        .nav-link:hover, .nav-link.active { background: #2c3136; color: white; border-left-color: #f97316; }
        .submenu { background-color: #1a1d20; display: none; }
        .submenu.show { display: block; }
        .card-stats { border: none; transition: transform 0.3s; }
        .card-stats:hover { transform: translateY(-5px); }
        .btn-logout { background-color: #dc3545; color: white; }
        .btn-logout:hover { background-color: #bb2d3b; }
    </style>
</head>
<body class="flex min-h-screen">

    <aside class="sidebar flex flex-col fixed h-full z-50">
        <div class="p-6 border-b border-gray-700">
            <div class="flex items-center gap-3">
                <img src="../assets/images/pjs.png" alt="Logo" class="h-10">
                <div>
                    <h1 class="text-white text-xs font-bold leading-tight uppercase">Admin Panel</h1>
                    <p class="text-[10px] text-gray-400 italic">POP Jasa System</p>
                </div>
            </div>
        </div>

        <nav class="flex-grow overflow-y-auto mt-4 text-sm font-semibold tracking-wide">
            <a href="index.php" class="nav-link active flex items-center gap-3 px-6 py-4">
                <i class="fas fa-gauge-high w-5"></i> Dashboard
            </a>

            <div>
                <div onclick="toggleSub('master-sub', 'master-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-database w-5 text-[10px]"></i> MASTER</span>
                    <i id="master-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="master-sub" class="submenu pl-12 text-[11px]">
                    <a href="master/manage-admin.php" class="block py-3 text-gray-400 hover:text-white uppercase">Manajemen Admin</a>
                    <a href="master/manage-kantor.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kantor</a>
                    <a href="master/manage-visi-misi.php" class="block py-3 text-gray-400 hover:text-white uppercase">Visi-Misi</a>
                    <a href="master/manage-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Klien</a>
                    <a href="master/manage-label.php" class="block py-3 text-gray-400 hover:text-white uppercase">Label</a>
                    <a href="master/manage-kelebihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kelebihan</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('konten-sub', 'konten-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-desktop w-5 text-[10px]"></i> KONTEN WEBSITE</span>
                    <i id="konten-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="konten-sub" class="submenu pl-12 text-[11px]">
                    <a href="konten/manage-artikel.php" class="block py-3 text-gray-400 hover:text-white uppercase">Artikel</a>
                    <a href="konten/manage-banner.php" class="block py-3 text-gray-400 hover:text-white uppercase">Banner</a>
                    <a href="konten/manage-galeri.php" class="block py-3 text-gray-400 hover:text-white uppercase">Galeri</a>
                    <a href="konten/manage-testimoni.php" class="block py-3 text-gray-400 hover:text-white uppercase">Testimoni</a>
                    <a href="konten/manage-bukti-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Bukti Klien</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('layanan-sub', 'layanan-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-briefcase w-5 text-[10px]"></i> LAYANAN</span>
                    <i id="layanan-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="layanan-sub" class="submenu pl-12 text-[11px]">
                    <a href="layanan/manage-ket-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Keterangan Layanan</a>
                    <a href="layanan/manage-data-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Data Layanan</a>
                    <a href="layanan/manage-layanan-legal.php" class="block py-3 text-gray-400 hover:text-white uppercase">Layanan Legal</a>
                    <a href="layanan/manage-pelatih.php" class="block py-3 text-gray-400 hover:text-white uppercase">Pelatih</a>
                    <a href="layanan/manage-pelatihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Pelatihan</a>
                    <a href="layanan/manage-affiliate.php" class="block py-3 text-gray-400 hover:text-white uppercase">Affiliate</a>
                </div>
            </div>

            <div class="px-6 py-4 text-[10px] text-gray-500 uppercase tracking-widest border-t border-gray-700 mt-2">Interaksi</div>
            <a href="interaksi/manage-kontak.php" class="nav-link flex items-center justify-between px-6 py-4">
                <span class="flex items-center gap-3"><i class="fas fa-envelope w-5"></i> Data Kontak</span>
                <span class="bg-red-500 text-white text-[10px] px-2 py-0.5 rounded-full">2</span>
            </a>
            <a href="interaksi/manage-pertanyaan.php" class="nav-link flex items-center gap-3 px-6 py-4">
                <i class="fas fa-question-circle w-5"></i> Data Pertanyaan
            </a>

            <a href="logout.php" class="btn-logout flex items-center gap-3 px-6 py-4 mt-10 transition-all font-bold">
                <i class="fas fa-power-off w-5 text-center"></i> Logout
            </a>
        </nav>
    </aside>

    <main class="flex-grow ml-[280px]">
        <header class="bg-white px-8 py-4 shadow-sm flex justify-between items-center sticky top-0 z-40">
            <div>
                <h2 class="text-xl font-bold text-gray-800 uppercase italic">Overview System</h2>
                <p class="text-[10px] text-gray-500">Selamat Datang, <?= $_SESSION['admin_nama'] ?></p>
            </div>
            <div class="flex items-center gap-3">
                <div class="text-right">
                    <p class="text-xs font-bold text-gray-800"><?= $_SESSION['admin_nama'] ?></p>
                    <p class="text-[10px] text-gray-500 italic">Administrator</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white border-2 border-orange-500 shadow-md">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </header>

        <div class="p-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8 uppercase italic font-bold">
                <div class="card-stats bg-blue-600 p-6 rounded-2xl text-white shadow-lg relative overflow-hidden">
                    <h3 class="text-sm opacity-80 uppercase">Total Klien</h3>
                    <p class="text-4xl font-extrabold mt-2"><?= $stats['klien'] ?></p>
                    <i class="fas fa-users absolute -right-4 -bottom-4 text-6xl opacity-20"></i>
                </div>
                <div class="card-stats bg-indigo-500 p-6 rounded-2xl text-white shadow-lg relative overflow-hidden">
                    <h3 class="text-sm opacity-80 uppercase">Artikel</h3>
                    <p class="text-4xl font-extrabold mt-2"><?= $stats['artikel'] ?></p>
                    <i class="fas fa-newspaper absolute -right-4 -bottom-4 text-6xl opacity-20"></i>
                </div>
                <div class="card-stats bg-emerald-500 p-6 rounded-2xl text-white shadow-lg relative overflow-hidden">
                    <h3 class="text-sm opacity-80 uppercase">Layanan</h3>
                    <p class="text-4xl font-extrabold mt-2"><?= $stats['layanan'] ?></p>
                    <i class="fas fa-briefcase absolute -right-4 -bottom-4 text-6xl opacity-20"></i>
                </div>
                <div class="card-stats bg-orange-500 p-6 rounded-2xl text-white shadow-lg relative overflow-hidden">
                    <h3 class="text-sm opacity-80 uppercase">Testimoni</h3>
                    <p class="text-4xl font-extrabold mt-2"><?= $stats['testimoni'] ?></p>
                    <i class="fas fa-comments absolute -right-4 -bottom-4 text-6xl opacity-20"></i>
                </div>
            </div>

            <div class="bg-white p-10 rounded-[35px] shadow-sm border border-gray-100 flex items-center relative overflow-hidden animate__animated animate__fadeInUp">
                <div class="z-10">
                    <h2 class="text-3xl font-extrabold text-gray-800 flex items-center gap-3 uppercase italic">
                        Selamat Datang <i class="fas fa-user-check text-blue-600 animate-bounce"></i>
                    </h2>
                    <p class="text-gray-500 mt-4 leading-relaxed max-w-3xl font-medium">
                        Anda login sebagai <span class="text-blue-600 font-bold italic underline">Admin Utama</span>. Gunakan menu navigasi di samping untuk mengelola Master Data, Konten Website, dan Layanan POPJASA secara akurat.
                    </p>
                </div>
                <div class="absolute -right-10 -top-10 w-40 h-40 bg-blue-50 rounded-full opacity-50"></div>
            </div>
        </div>
    </main>

    <script>
        function toggleSub(id, iconId) {
            const submenu = document.getElementById(id);
            const icon = document.getElementById(iconId);
            submenu.classList.toggle('show');
            icon.style.transform = submenu.classList.contains('show') ? 'rotate(-90deg)' : 'rotate(0deg)';
        }
    </script>
</body>
</html>