<?php
session_start();
include '../../config/database.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// Data Dummy (Nanti ganti dengan query SQL: SELECT * FROM klien ORDER BY id DESC)
$data_klien = [
    ['id' => 1, 'nama' => 'Klien 6', 'foto' => 'logo-bni.png'],
    ['id' => 2, 'nama' => 'Klien 5', 'foto' => 'client-2.png'],
    ['id' => 3, 'nama' => 'Klien 4', 'foto' => 'client-3.png'],
    ['id' => 4, 'nama' => 'Klien 3', 'foto' => 'client-4.png'],
    ['id' => 5, 'nama' => 'Klien 2', 'foto' => 'client-5.png'],
    ['id' => 6, 'nama' => 'Klien 1', 'foto' => 'client-6.png'],
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Klien - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f4f7fe; }
        .sidebar { background-color: #212529; width: 280px; transition: all 0.3s; }
        .nav-link { color: #adb5bd; transition: all 0.2s; border-left: 4px solid transparent; cursor: pointer; }
        .nav-link:hover, .nav-link.active { background: #2c3136; color: white; border-left-color: #f97316; }
        .submenu { background-color: #1a1d20; display: none; }
        .submenu.show { display: block; }
        .glass-card { background: white; border-radius: 20px; border: 1px solid #edf2f7; box-shadow: 0 10px 25px rgba(0,0,0,0.02); }
        .btn-logout { background-color: #dc3545; color: white; }
        
        .client-logo-frame {
            width: 60px;
            height: 60px;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: white;
            overflow: hidden;
            padding: 5px;
        }
    </style>
</head>
<body class="flex min-h-screen">

    <aside class="sidebar flex flex-col fixed h-full z-50">
        <div class="p-6 border-b border-gray-700">
            <div class="flex items-center gap-3">
                <img src="../../assets/images/pjs.png" alt="Logo" class="h-10">
                <div>
                    <h1 class="text-white text-xs font-bold leading-tight uppercase">Admin Panel</h1>
                    <p class="text-[10px] text-gray-400 italic font-medium">Pop Jasa System</p>
                </div>
            </div>
        </div>

        <nav class="flex-grow overflow-y-auto mt-4 text-sm font-semibold tracking-wide">
            <a href="../index.php" class="nav-link flex items-center gap-3 px-6 py-4">
                <i class="fas fa-gauge-high w-5"></i> Dashboard
            </a>

            <div>
                <div onclick="toggleSub('master-sub', 'master-icon')" class="nav-link active w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-database w-5"></i> MASTER</span>
                    <i id="master-icon" class="fas fa-chevron-left text-[10px] -rotate-90 transition-transform"></i>
                </div>
                <div id="master-sub" class="submenu show pl-12 text-[11px]">
                    <a href="manage-admin.php" class="block py-3 text-gray-400 hover:text-white uppercase">Manajemen Admin</a>
                    <a href="manage-kantor.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kantor</a>
                    <a href="manage-visi-misi.php" class="block py-3 text-gray-400 hover:text-white uppercase">Visi-Misi</a>
                    <a href="manage-klien.php" class="block py-3 text-white font-bold uppercase underline">Klien</a>
                    <a href="manage-label.php" class="block py-3 text-gray-400 hover:text-white uppercase">Label</a>
                    <a href="manage-kelebihan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Kelebihan</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('konten-sub', 'konten-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-desktop w-5"></i> KONTEN WEBSITE</span>
                    <i id="konten-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="konten-sub" class="submenu pl-12 text-[11px]">
                    <a href="../konten/manage-artikel.php" class="block py-3 text-gray-400 hover:text-white uppercase">Artikel</a>
                    <a href="../konten/manage-banner.php" class="block py-3 text-gray-400 hover:text-white uppercase">Banner</a>
                    <a href="../konten/manage-galeri.php" class="block py-3 text-gray-400 hover:text-white uppercase">Galeri</a>
                    <a href="../konten/manage-testimoni.php" class="block py-3 text-gray-400 hover:text-white uppercase">Testimoni</a>
                    <a href="../konten/manage-bukti-klien.php" class="block py-3 text-gray-400 hover:text-white uppercase">Bukti Klien</a>
                </div>
            </div>

            <div>
                <div onclick="toggleSub('layanan-sub', 'layanan-icon')" class="nav-link w-full flex items-center justify-between px-6 py-4">
                    <span class="flex items-center gap-3"><i class="fas fa-briefcase w-5"></i> LAYANAN</span>
                    <i id="layanan-icon" class="fas fa-chevron-left text-[10px] transition-transform"></i>
                </div>
                <div id="layanan-sub" class="submenu pl-12 text-[11px]">
                    <a href="../layanan/manage-ket-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Keterangan Layanan</a>
                    <a href="../layanan/manage-data-layanan.php" class="block py-3 text-gray-400 hover:text-white uppercase">Data Layanan</a>
                    <a href="../layanan/manage-layanan-legal.php" class="block py-3 text-gray-400 hover:text-white uppercase">Layanan Legal</a>
                </div>
            </div>

            <a href="../logout.php" class="flex items-center gap-3 px-6 py-4 mt-10 bg-red-600 text-white font-bold uppercase text-xs transition-all hover:bg-red-700">
                <i class="fas fa-power-off w-5 text-center"></i> Logout
            </a>
        </nav>
    </aside>

    <main class="flex-grow ml-[280px]">
        <header class="bg-white px-8 py-4 shadow-sm flex justify-between items-center sticky top-0 z-40 border-b">
            <div>
                <h2 class="text-xl font-bold text-gray-800 uppercase italic">Dashboard</h2>
                <p class="text-[10px] text-gray-500">Ringkasan aktivitas sistem</p>
            </div>
            <div class="flex items-center gap-3">
                <div class="text-right">
                    <p class="text-xs font-bold text-gray-800"><?= $_SESSION['admin_nama'] ?></p>
                    <p class="text-[10px] text-gray-500 italic font-medium">Administrator</p>
                </div>
                <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white border-2 border-orange-500 shadow-md">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </header>

        <div class="p-8">
            <div class="glass-card p-6 mb-8 flex flex-col md:flex-row justify-between items-center border-l-8 border-blue-600">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-xl flex items-center justify-center text-xl">
                        <i class="fas fa-users-viewfinder"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl font-extrabold text-gray-800 tracking-tight uppercase italic">Data Klien</h3>
                        <p class="text-xs text-gray-500 font-medium italic">Kelola daftar klien perusahaan</p>
                    </div>
                </div>
                <button class="mt-4 md:mt-0 bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl font-bold text-sm shadow-lg shadow-blue-100 transition-all flex items-center gap-2 uppercase tracking-tighter">
                    <i class="fas fa-plus text-xs"></i> Tambah Klien
                </button>
            </div>

            <div class="glass-card overflow-hidden">
                <div class="p-6 border-b border-gray-50 flex justify-between items-center bg-gray-50/30 font-bold italic uppercase">
                    <div class="flex items-center gap-2 text-sm text-gray-600">
                        Tampilkan 
                        <select class="border rounded-lg px-2 py-1 outline-none focus:ring-2 focus:ring-blue-400">
                            <option>10</option>
                            <option>25</option>
                        </select> 
                        data
                    </div>
                    <div class="relative">
                        <input type="text" placeholder="Cari data..." class="pl-4 pr-10 py-2 border rounded-xl outline-none focus:ring-2 focus:ring-blue-400 text-sm w-64">
                        <i class="fas fa-search absolute right-3 top-3 text-gray-400"></i>
                    </div>
                </div>

                <div class="overflow-x-auto p-4 font-bold italic uppercase">
                    <table class="w-full text-left">
                        <thead>
                            <tr class="text-[11px] font-black text-gray-400 tracking-widest border-b">
                                <th class="p-4 w-16 text-center">NO</th>
                                <th class="p-4">NAMA KLIEN</th>
                                <th class="p-4 text-center">FOTO</th>
                                <th class="p-4 text-center">AKSI</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm text-gray-700">
                            <?php $no = 1; foreach($data_klien as $row): ?>
                            <tr class="border-b border-gray-50 hover:bg-slate-50 transition-colors">
                                <td class="p-5 text-center text-gray-400"><?= $no++ ?></td>
                                <td class="p-5 text-gray-800 font-extrabold uppercase italic"><?= $row['nama'] ?></td>
                                <td class="p-5">
                                    <div class="client-logo-frame mx-auto shadow-sm">
                                        <img src="../../assets/images/pjs.png" class="object-contain max-h-full" alt="Logo Klien">
                                    </div>
                                </td>
                                <td class="p-5">
                                    <div class="flex justify-center gap-2">
                                        <button class="bg-amber-50 text-amber-600 border border-amber-100 hover:bg-amber-500 hover:text-white px-3 py-1.5 rounded-lg text-[11px] font-black transition-all flex items-center gap-1 uppercase">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <button class="bg-red-50 text-red-600 border border-red-100 hover:bg-red-500 hover:text-white px-3 py-1.5 rounded-lg text-[11px] font-black transition-all flex items-center gap-1 uppercase">
                                            <i class="fas fa-trash"></i> Hapus
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="p-6 flex flex-col md:flex-row justify-between items-center gap-4 bg-gray-50/30 border-t font-bold italic uppercase">
                    <p class="text-xs text-gray-500">Menampilkan 1 - 6 dari 6 data</p>
                    <div class="flex items-center gap-1">
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg border bg-white text-gray-400 hover:bg-blue-600 transition"><i class="fas fa-chevron-left text-[10px]"></i></button>
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg bg-blue-600 text-white text-xs font-bold shadow-md shadow-blue-100">1</button>
                        <button class="w-8 h-8 flex items-center justify-center rounded-lg border bg-white text-gray-400 hover:bg-blue-600 transition"><i class="fas fa-chevron-right text-[10px]"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        function toggleSub(id, iconId) {
            const submenu = document.getElementById(id);
            const icon = document.getElementById(iconId);
            submenu.classList.toggle('show');
            icon.style.transform = submenu.classList.contains('show') ? 'rotate(-90deg)' : 'rotate(0deg)';
        }
    </script>
</body>
</html>