<?php
session_start();
include 'config/database.php';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Artikel & Wawasan - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <style>
        body { font-family: 'Helvetica', 'Arial', sans-serif; scroll-behavior: smooth; }
        * { font-style: normal !important; }
        .glass-nav { background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(10px); }
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        
        /* Custom UI Style from Image */
        .article-card-main { border-radius: 40px; overflow: hidden; transition: all 0.4s ease; }
        .article-card-main:hover { transform: translateY(-5px); box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15); }
        .bg-blue-accent { background: #f0f7ff; }
        .pagination-btn { width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; border-radius: 50%; transition: all 0.3s; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="../assets/images/pjs.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm">
                <a href="index.php" class="hover:text-blue-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-blue-600 transition py-8 tracking-wider text-xs">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 text-left">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-blue-600 transition uppercase text-xs">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-blue-600 transition uppercase text-xs">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-blue-600 transition uppercase text-xs">Program Affiliate</a>
                <a href="artikel.php" class="text-blue-600 border-b-2 border-blue-600 transition uppercase text-xs">Artikel</a>
            </div>

            <div class="flex items-center gap-4">
                <a href="https://wa.me/628563162047" class="hidden sm:flex border border-blue-600 text-blue-600 px-5 py-2 rounded-full font-black hover:bg-blue-600 hover:text-white transition text-[10px] items-center gap-2 uppercase">
                    <i class="fab fa-whatsapp"></i> Konsultasi Wa Gratis
                </a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-12">
        <div class="bg-blue-accent rounded-[40px] p-10 md:p-20 text-center relative overflow-hidden">
            <span class="bg-blue-100 text-blue-600 text-[10px] px-4 py-1 rounded-lg mb-6 inline-block font-black uppercase tracking-widest"><i class="fas fa-newspaper mr-2"></i> Artikel & Insight</span>
            <h1 class="text-4xl md:text-6xl font-extrabold leading-tight mb-6 tracking-tighter">Informasi & Wawasan Terbaru <br> <span class="text-blue-600">Untuk Anda</span></h1>
            <p class="text-slate-500 max-w-2xl mx-auto font-bold text-xs md:text-sm leading-relaxed lowercase first-letter:uppercase">Temukan berbagai artikel, tips, dan insight terbaru seputar layanan, bisnis, serta informasi penting yang kami rangkum secara aktual dan terpercaya.</p>
            <div class="absolute top-0 right-0 w-32 h-32 bg-blue-200/30 rounded-bl-[100px]"></div>
            <div class="absolute bottom-0 left-0 w-32 h-32 bg-blue-200/30 rounded-tr-[100px]"></div>
        </div>
    </section>

    <section class="container mx-auto px-6 pb-20">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-10">
            
            <div class="lg:col-span-2 space-y-8">
                
                <div class="article-card-main bg-white border border-slate-100 shadow-sm group">
                    <div class="relative h-[350px] overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?q=80&w=1200" class="w-full h-full object-cover group-hover:scale-105 transition duration-700">
                        <span class="absolute top-6 left-6 bg-blue-600 text-white text-[9px] px-4 py-1.5 rounded-full font-black uppercase">Jasa Pembuatan Website</span>
                        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-transparent to-transparent"></div>
                        <div class="absolute bottom-8 left-8 right-8 text-white">
                            <p class="text-[10px] font-bold mb-2 opacity-80 uppercase">21 Dec 2025</p>
                            <h2 class="text-2xl md:text-3xl font-black leading-tight uppercase tracking-tight">Jasa Pengurusan LKPM Terpercaya Laporan Beres, Bisnis Fokus, Harga Terbaik. Hubungi Sekarang!</h2>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <?php for($i=1;$i<=4;$i++): ?>
                    <div class="article-card-main bg-white border border-slate-100 shadow-sm group p-4">
                        <div class="relative h-48 rounded-[30px] overflow-hidden mb-6">
                            <img src="https://images.unsplash.com/photo-1432888622747-4eb9a8f2c207?q=80&w=600" class="w-full h-full object-cover group-hover:scale-105 transition duration-700">
                            <span class="absolute top-4 left-4 bg-blue-600 text-white text-[8px] px-3 py-1 rounded-full font-black uppercase"><?= ($i % 2 == 0) ? 'Jasa Pembuatan CV' : 'Jasa Pelaporan LKPM' ?></span>
                        </div>
                        <p class="text-slate-400 text-[9px] font-bold mb-2 uppercase">21 Dec 2025</p>
                        <h3 class="text-sm font-black leading-relaxed text-slate-800 uppercase tracking-tight group-hover:text-blue-600 transition">Jasa Pengurusan LKPM Terpercaya Laporan Beres, Bisnis Fokus, Harga Terbaik...</h3>
                    </div>
                    <?php endfor; ?>
                </div>

                <div class="flex justify-center items-center gap-4 py-10">
                    <button class="pagination-btn border border-slate-200 text-slate-400 hover:border-blue-600 hover:text-blue-600 transition"><i class="fas fa-chevron-left"></i></button>
                    <button class="pagination-btn bg-blue-50 text-blue-600 font-black">1</button>
                    <button class="pagination-btn bg-blue-600 text-white font-black shadow-lg shadow-blue-200">2</button>
                    <button class="pagination-btn border border-slate-200 text-slate-400 hover:border-blue-600 hover:text-blue-600 transition"><i class="fas fa-chevron-right"></i></button>
                </div>
            </div>

            <div class="space-y-10">
                <div class="bg-white rounded-[40px] border border-slate-100 shadow-sm p-10 relative overflow-hidden">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-blue-600 text-white rounded-2xl flex items-center justify-center text-lg shadow-lg shadow-blue-100">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <h3 class="text-xl font-extrabold tracking-tight">Arsip Artikel</h3>
                    </div>
                    <ul class="space-y-4">
                        <li class="flex justify-between items-center bg-slate-50 p-4 rounded-2xl hover:bg-blue-50 transition group cursor-pointer">
                            <span class="text-[11px] font-black text-slate-600 group-hover:text-blue-600">December 2025</span>
                            <span class="bg-white text-blue-600 text-[10px] w-8 h-8 flex items-center justify-center rounded-full font-black shadow-sm group-hover:bg-blue-600 group-hover:text-white transition">7</span>
                        </li>
                    </ul>
                    <div class="absolute top-0 right-0 w-20 h-20 bg-blue-50 rounded-bl-full"></div>
                </div>
                
                <div class="bg-slate-900 rounded-[40px] p-10 text-white shadow-xl">
                    <h3 class="text-lg font-black mb-6 uppercase tracking-widest border-b border-white/10 pb-4">Cari Informasi</h3>
                    <div class="relative">
                        <input type="text" placeholder="KETIK KEYWORD..." class="w-full bg-white/10 border-none rounded-2xl py-4 px-6 text-[10px] font-black placeholder:text-white/40 focus:ring-2 focus:ring-blue-500">
                        <button class="absolute right-4 top-1/2 -translate-y-1/2 text-blue-400"><i class="fas fa-search"></i></button>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-20 pb-10 px-6 uppercase font-black">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
                <div class="flex flex-col items-center md:items-start">
                    <img src="../assets/images/pjs.png" class="h-16 mb-6 brightness-125">
                    <p class="text-[11px] mb-6 text-slate-400 leading-tight">Solusi Perijinan Usaha Anda</p>
                    <div class="space-y-3 text-[11px] text-slate-300">
                        <p><i class="fas fa-phone-alt mr-2 text-orange-500"></i> Phone : 08563162047</p>
                        <p><i class="fab fa-whatsapp mr-2 text-orange-500"></i> WhatsApp : 08563162047</p>
                        <p class="lowercase"><i class="fas fa-envelope mr-2 text-orange-500"></i> popjasa@gmail.com</p>
                    </div>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Pengurusan Legalitas</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pembuatan CV</li>
                        <li>Jasa Pengurusan NIB</li>
                        <li>Jasa Pembuatan PT</li>
                        <li>Jasa Pembuatan UD</li>
                        <li>Jasa Pengurusan PIRT</li>
                        <li>Jasa Pendirian PT Perorangan</li>
                        <li>Jasa Pendirian PT PMA</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Pelaporan Pajak</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pelaporan SPT Tahunan</li>
                        <li>Jasa Tax Amnesty</li>
                        <li>Jasa Pengukuhan PKP</li>
                        <li>Jasa Pelaporan LKPM</li>
                        <li>Jasa Pembuatan NPWP</li>
                        <li>Jasa Pembuatan Kode Billing</li>
                        <li>Jasa Pembuatan Faktur Pajak</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Digital Marketing</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pembuatan Website</li>
                        <li>Jasa Pembuatan Compro</li>
                        <li>Jasa Pembuatan Logo</li>
                        <li>Jasa Pembuatan Design Flyer</li>
                    </ul>
                </div>
            </div>
            <div class="pt-8 border-t border-white/10 text-center text-[10px] text-slate-500 tracking-widest">
                Copyright ©2025 POP Jasa Solusi Perizinan Usaha Anda
            </div>
        </div>
    </footer>

</body>
</html>