CREATE DATABASE IF NOT EXISTS db_popjasa;
USE db_popjasa;

-- 1. Tabel Admin
CREATE TABLE IF NOT EXISTS `admin` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `admin` (`username`, `password`, `nama_lengkap`) VALUES 
('admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator');

-- 2. Tabel Artikel (Database Pusat)
CREATE TABLE IF NOT EXISTS `articles` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `articles` (`title`) VALUES 
('PENTINGNYA AKTA NOTARIS'), ('MANFAAT NPWP BADAN'), ('SYARAT OSS RBA'), 
('IZIN EDAR BPOM'), ('LEGALITAS CV TERBARU'), ('TIPS PAJAK UMKM'), 
('CARA DAFTAR MEREK HAKI'), ('PANDUAN PENDIRIAN PT 2026');

-- 3. Tabel Pin Artikel Home
CREATE TABLE IF NOT EXISTS `home_pinned_articles` (
  `slot` int(11) PRIMARY KEY,
  `article_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_pinned_articles` (`slot`, `article_id`) VALUES (1, 8), (2, 7), (3, 6);

-- 4. Tabel Testimoni Whatsapp
CREATE TABLE IF NOT EXISTS `home_chat_slides` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_chat_slides` (`image`, `label`) VALUES 
('chat1.jpg', 'Testimoni Surabaya #1'), ('chat2.jpg', 'Testimoni Sidoarjo #1'),
('chat3.jpg', 'Izin PT Malang'), ('chat4.jpg', 'PIRT Gresik'), ('chat5.jpg', 'NIB Jakarta');

-- 5. Tabel Trusted Partners
CREATE TABLE IF NOT EXISTS `home_partners` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `image` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_partners` (`image`, `label`) VALUES 
('oss.png', 'OSS RBA'), ('kemenkumham.png', 'KEMENKUMHAM'), ('pajak.png', 'DITJEN PAJAK'), 
('bpom.png', 'BPOM RI'), ('mui.png', 'MUI HALAL');

-- 6. Tabel FAQ
CREATE TABLE IF NOT EXISTS `home_faq` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `question` text NOT NULL,
  `answer` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `home_faq` (`question`, `answer`) VALUES 
('Lama proses PT?', '7-10 hari kerja.'), ('Bisa urus NPWP?', 'Bisa, Pribadi & Badan.'),
('Syarat CV?', 'KTP, KK, NPWP.'), ('Online seluruh RI?', 'Ya, 9 cabang.'),
('Cara bayar?', 'Transfer Bank Resmi.');