<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Digital Marketing - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { 
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; 
            scroll-behavior: smooth; 
        }
        .bg-gradient-indigo { background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 50%, #312e81 100%); }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        
        /* Dropdown Desktop */
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }

        /* Mobile Menu */
        #mobileMenu { transition: all 0.3s ease-in-out; max-height: 0; opacity: 0; pointer-events: none; overflow: hidden; }
        #mobileMenu.active { max-height: 100vh; opacity: 1; pointer-events: auto; }

        /* Sosmed Animation */
        .sosmed-icon { transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .sosmed-icon:hover { transform: translateY(-8px) scale(1.15); filter: brightness(1.2); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }

        /* Force Reset Italic */
        .italic, i, body { font-style: normal !important; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                    <div class="flex flex-col text-left leading-none">
                        <span class="text-xl font-extrabold tracking-tighter text-indigo-900">POPJASA</span>
                        <span class="text-[8px] font-bold text-orange-500 tracking-widest mt-1">Solusi Perijinan Usaha</span>
                    </div>
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm uppercase font-black">
                <a href="index.php" class="hover:text-indigo-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 tracking-wider text-xs font-black">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 text-left leading-tight">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-t border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-y border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 bg-indigo-50 text-indigo-600 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase text-xs font-black">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 uppercase text-xs font-black">Tentang Kami</a>
                <a href="#" class="hover:text-indigo-600 uppercase text-xs font-black">Program Affiliate</a>
                <a href="#artikel" class="hover:text-indigo-600 uppercase text-xs font-black">Artikel</a>
            </div>

            <div class="flex items-center gap-4 uppercase font-black">
                <a href="https://wa.me/6281229995779" class="hidden sm:flex bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp text-lg"></i> Konsultasi
                </a>
                <button id="hamburgerBtn" class="lg:hidden text-indigo-900 text-2xl focus:outline-none"><i class="fas fa-bars"></i></button>
            </div>
        </div>

        <div id="mobileMenu" class="lg:hidden bg-white border-t border-slate-100 shadow-xl absolute w-full left-0 uppercase font-black">
            <div class="flex flex-col p-6 space-y-4 text-xs tracking-widest leading-tight">
                <a href="index.php" class="py-2 border-b border-slate-50 leading-tight">Beranda</a>
                <div onclick="document.getElementById('mobileSub').classList.toggle('hidden')" class="py-2 border-b border-slate-50 flex justify-between items-center cursor-pointer">
                    <span>Layanan</span> <i class="fas fa-chevron-down text-[10px]"></i>
                </div>
                <div id="mobileSub" class="hidden flex flex-col pl-4 space-y-3 bg-slate-50 p-4 rounded-xl text-left">
                    <a href="jasa-perizinan.php">Jasa Perizinan</a>
                    <a href="izin-lanjutan.php">Jasa Lanjutan</a>
                    <a href="perpajakan.php">Perpajakan</a>
                    <a href="digital-marketing.php" class="text-indigo-600">Digital Marketing</a>
                </div>
                <a href="alur-proses.php" class="py-2 border-b border-slate-50 leading-tight">Alur Proses</a>
                <a href="tentang-kami.php" class="py-2 border-b border-slate-50 leading-tight">Tentang Kami</a>
                <a href="program-affiliate.php" class="py-2 border-b border-slate-50 leading-tight">Program Affiliate</a>
                <a href="artikel.php" class="py-2 border-b border-slate-50 leading-tight">Artikel</a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-12">
        <div class="bg-gradient-to-r from-pink-100 to-indigo-100 rounded-[40px] overflow-hidden flex flex-col lg:flex-row items-center relative min-h-[400px]">
            <div class="p-12 lg:w-3/5 z-10 leading-tight">
                <h1 class="text-4xl lg:text-5xl font-black mb-6 uppercase text-slate-900 leading-tight">Digital Marketing<br>Bisnis Strategis</h1>
                <p class="text-lg text-slate-600 mb-8 leading-relaxed max-w-xl font-bold uppercase">
                    Optimasi visibilitas bisnis Anda melalui SEO, Facebook Ads, dan Google Ads untuk pertumbuhan yang pesat dan berkelanjutan.
                </p>
                <button class="bg-indigo-600 text-white px-8 py-3 rounded-xl font-black text-xs uppercase shadow-xl hover:bg-indigo-700 transition">
                    Konsultasi Gratis
                </button>
            </div>
            <div class="lg:w-2/5 w-full h-full min-h-[300px] flex items-center justify-center p-8">
                <img src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?auto=format&fit=crop&q=80&w=800" class="rounded-3xl shadow-2xl rotate-3">
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 uppercase font-black">
        <div class="max-w-4xl mx-auto text-center leading-relaxed">
            <h2 class="text-3xl font-black mb-8 border-b-4 border-indigo-600 inline-block pb-2">PROFIL</h2>
            <p class="text-slate-600 font-bold text-sm md:text-base mb-6">
                Latar Belakang DM Site POPJASA Dalam era digital yang semakin maju, kemampuan untuk memahami dan menguasai strategi pemasaran digital menjadi sangat penting.
            </p>
            <p class="text-slate-600 font-bold text-sm md:text-base">
                Meningkatkan kehadiran online dan mencapai target pasar yang lebih luas melalui program kelas digital marketing yang dirancang khusus.
            </p>
        </div>
    </section>

    <section class="container mx-auto px-6 py-10 text-center uppercase font-black">
        <h2 class="text-2xl font-black mb-12">Profil Pelatih DM Site POPJASA</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php for($k=1;$k<=3;$k++): ?>
            <div class="bg-white p-8 rounded-[40px] border border-slate-200 shadow-sm hover:shadow-xl transition font-black">
                <div class="w-32 h-32 bg-slate-200 rounded-full mx-auto mb-6 overflow-hidden border-4 border-indigo-50">
                     <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?auto=format&fit=crop&q=80&w=200" class="w-full h-full object-cover">
                </div>
                <h3 class="font-black text-indigo-900 mb-2">NAMA PELATIH</h3>
                <p class="text-[10px] text-slate-500 font-bold leading-relaxed">Expert Trainer Digital Marketing & SEO Specialist.</p>
            </div>
            <?php endfor; ?>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 text-center uppercase font-black">
        <h2 class="text-3xl font-black mb-12">PELATIHAN</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
            <?php 
            $pelatihan = [
                ['name' => 'SEO Optimization', 'desc' => 'Strategi ranking #1 di mesin pencari.'],
                ['name' => 'Facebook & IG Ads', 'desc' => 'Beriklan tepat sasaran untuk konversi tinggi.'],
                ['name' => 'Google Ads Specialist', 'desc' => 'Kuasai pencarian berbayar secara efisien.'],
                ['name' => 'Content Marketing', 'desc' => 'Produksi konten yang menarik dan menjual.']
            ];
            foreach($pelatihan as $p): ?>
            <div class="bg-white flex flex-col md:flex-row items-center p-8 rounded-[40px] border border-slate-200 shadow-sm hover:shadow-2xl transition group font-black">
                <div class="w-full md:w-1/3 h-32 bg-slate-100 rounded-2xl mb-4 md:mb-0 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1533750349088-cd871a92f312?auto=format&fit=crop&q=80&w=300" class="w-full h-full object-cover group-hover:scale-110 transition duration-500">
                </div>
                <div class="md:w-2/3 md:pl-8 text-left">
                    <h3 class="font-black text-indigo-900 text-lg mb-2 uppercase"><?= $p['name'] ?></h3>
                    <p class="text-[11px] text-slate-500 font-bold uppercase"><?= $p['desc'] ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <section id="artikel" class="bg-slate-100 py-24 px-6 border-t border-slate-200 uppercase font-black">
        <div class="container mx-auto text-center font-black">
            <h2 class="text-3xl font-black uppercase mb-16 tracking-tighter">Artikel Mengenai Pelatihan</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-10 font-black">
                <?php for($j=1;$j<=6;$j++): ?>
                <div class="bg-white rounded-[40px] overflow-hidden border border-slate-200 shadow-sm group hover:shadow-2xl transition duration-500 uppercase font-black">
                    <div class="h-48 bg-slate-300 overflow-hidden relative font-black">
                         <img src="https://images.unsplash.com/photo-1432888622747-4eb9a8f2c207?auto=format&fit=crop&q=80&w=600" class="w-full h-full object-cover group-hover:scale-110 transition duration-1000">
                    </div>
                    <div class="p-8">
                        <h3 class="font-black text-sm mb-4 leading-tight uppercase tracking-tighter">Wawasan Digital Marketing</h3>
                        <p class="text-slate-500 text-[10px] font-bold mb-6 tracking-tight opacity-70 leading-relaxed uppercase">Update tren pemasaran digital terbaru tahun 2026.</p>
                        <a href="#" class="text-indigo-600 font-black text-[9px] border-b-2 border-indigo-600 pb-1 tracking-widest">Selengkapnya</a>
                    </div>
                </div>
                <?php endfor; ?>
            </div>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-24 pb-12 px-6 leading-tight uppercase font-black">
        <div class="container mx-auto uppercase font-black">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-12 lg:gap-20 mb-24 text-center md:text-left">
                <div class="flex flex-col items-center md:items-start uppercase font-black">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" class="h-20 mb-6 brightness-125 contrast-125">
                    <div class="flex flex-col mb-8 uppercase font-black">
                        <span class="text-4xl font-black tracking-tighter text-white leading-none">POP<span class="text-orange-500 underline">JASA</span></span>
                        <span class="text-[10px] font-black text-slate-400 tracking-[0.3em] mt-3 border-t border-white/10 pt-3">Solusi Perijinan Usaha Anda</span>
                    </div>
                    <div class="space-y-4 text-[13px] font-black text-slate-300 tracking-tighter mb-8 uppercase font-black">
                        <p>Phone : (031) 59181278</p>
                        <p>WhatsApp / SMS : 081229995779</p>
                        <p>Email : popjasa@gmail.com</p>
                    </div>
                    <div class="flex gap-4 pt-4 uppercase font-black">
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-gradient-to-tr from-yellow-500 via-pink-600 to-purple-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-black flex items-center justify-center text-lg border border-white/20 shadow-lg transition font-black"><i class="fab fa-tiktok"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-green-500 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>

                <div class="font-black">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none">Layanan Pengurusan<br>Legalitas Usaha</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li>Jasa Pembuatan CV</li>
                        <li>Jasa Pengurusan NIB</li>
                        <li>Jasa Pembuatan PT</li>
                        <li>Jasa Pembuatan UD</li>
                        <li class="leading-tight">Jasa Pengurusan PIRT</li>
                        <li class="leading-tight">Jasa Pendirian PT Perorangan</li>
                        <li>Jasa Pendirian PT PMA</li>
                    </ul>
                </div>

                <div class="font-black">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none">Layanan Pelaporan dan<br>Administrasi Pajak</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider font-black">
                        <li class="leading-tight">Jasa Pelaporan SPT Tahunan</li>
                        <li>Jasa Tax Amnesty</li>
                        <li>Jasa Pengukuhan PKP</li>
                        <li>Jasa Pelaporan LKPM</li>
                        <li>Jasa Pembuatan NPWP</li>
                        <li>Jasa Kode Billing Pajak</li>
                        <li>Jasa Pembuatan Faktur Pajak</li>
                    </ul>
                </div>

                <div class="font-black">
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase tracking-tighter leading-none tracking-widest">Layanan Digital<br>Marketing</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li>Website Perusahaan</li>
                        <li>Company Profile</li>
                        <li>Logo Usaha</li>
                        <li>Desain Flyer Promosi</li>
                    </ul>
                </div>
            </div>
            <div class="pt-12 border-t border-white/5 text-center text-slate-500 text-[11px] tracking-[0.4em] uppercase font-black">
                Copyright @2026 www.popjasa.id
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6281229995779" class="fixed bottom-10 right-10 w-16 h-16 bg-green-500 text-white rounded-full flex items-center justify-center text-4xl shadow-3xl z-[999] hover:scale-110 transition border-8 border-[#001c3d] animate-bounce font-black uppercase">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script>
        const btn = document.getElementById('hamburgerBtn');
        const menu = document.getElementById('mobileMenu');
        btn.addEventListener('click', (e) => { e.stopPropagation(); menu.classList.toggle('active'); });
        document.addEventListener('click', (e) => { if (menu.classList.contains('active') && !menu.contains(e.target) && e.target !== btn) menu.classList.remove('active'); });
    </script>
</body>
</html>