<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>POPJASA - Solusi Perijinan Usaha Anda</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; scroll-behavior: smooth; }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        #mobileMenu { transition: all 0.3s ease-in-out; max-height: 0; opacity: 0; pointer-events: none; overflow: hidden; }
        #mobileMenu.active { max-height: 100vh; opacity: 1; pointer-events: auto; }
        
        /* FAQ Animation */
        .faq-answer { max-height: 0; overflow: hidden; transition: all 0.4s ease-out; opacity: 0; }
        .faq-item.active .faq-answer { max-height: 300px; opacity: 1; padding-top: 1rem; }
        .faq-item.active .faq-icon { transform: rotate(180deg); color: #f97316; }
        
        .italic, i { font-style: normal !important; }
        .swiper-pagination-bullet-active { background: #3b82f6 !important; }
        
        /* Custom UI components from image */
        .usp-card { background: #fef9c3; transition: all 0.3s ease; }
        .usp-card:hover { background: #fef08a; transform: translateY(-5px); }
        .chat-img { height: 450px; width: 100%; object-fit: cover; border-radius: 30px; }
        .service-list-bg { background-color: #f1f5f9; border-radius: 50px; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="assets/images/pjs.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm">
                <a href="index.php" class="text-blue-600 border-b-2 border-blue-600 transition">Home</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 tracking-wider text-xs">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 text-left">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-t border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-y border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase text-xs">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 uppercase text-xs">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-indigo-600 uppercase text-xs">Program Affiliate</a>
                <a href="artikel.php" class="hover:text-indigo-600 uppercase text-xs">Artikel</a>
            </div>

            <div class="flex items-center gap-4">
                <a href="https://wa.me/628563162047" class="hidden sm:flex border border-blue-600 text-blue-600 px-5 py-2 rounded-full font-black hover:bg-blue-600 hover:text-white transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp"></i> Konsultasi Wa Gratis
                </a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-10">
        <div class="bg-gradient-to-r from-blue-100 to-emerald-100 rounded-[40px] p-10 md:p-20 flex flex-col md:flex-row items-center justify-between gap-10 overflow-hidden relative min-h-[500px]">
            <div class="md:w-1/2 z-10">
                <h1 class="text-4xl md:text-6xl font-extrabold leading-tight mb-4 tracking-tighter">Jasa Pendaftaran <br> Merk Dagang HAKI & Paten</h1>
                <p class="text-slate-600 text-sm mb-8 font-bold leading-relaxed lowercase first-letter:uppercase">Lindungi identitas bisnis dan inovasi anda secara legal. Proses mudah, cepat dan ditangani langsung oleh profesional terpercaya.</p>
                <a href="#" class="bg-blue-600 text-white px-8 py-4 rounded-2xl inline-flex items-center gap-3 font-black shadow-lg shadow-blue-200 hover:bg-blue-700 transition">
                    <i class="fab fa-whatsapp text-xl"></i> Konsultasi Gratis
                </a>
            </div>
            <div class="md:w-1/2">
                <img src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?q=80&w=800" class="rounded-[40px] shadow-2xl" alt="Hero Image">
            </div>
            <div class="absolute bottom-10 left-1/2 -translate-x-1/2 flex gap-2">
                <div class="w-12 h-1.5 bg-blue-600 rounded-full"></div>
                <div class="w-12 h-1.5 bg-slate-300 rounded-full"></div>
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 mb-20">
        <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
            <?php 
            $usps = [
                ['i' => 'hand-holding-dollar', 't' => 'Termurah'],
                ['i' => 'handshake', 't' => 'Promo Bayar Setelah Jadi'],
                ['i' => 'users', 't' => 'Komunitas Pengusaha & Relasi'],
                ['i' => 'bolt', 't' => 'Tercepat'],
                ['i' => 'award', 't' => 'Terjamin'],
            ];
            foreach($usps as $u): ?>
            <div class="usp-card p-6 rounded-3xl flex flex-col items-center text-center justify-center gap-4 group">
                <div class="w-12 h-12 bg-white rounded-full flex items-center justify-center shadow-sm group-hover:scale-110 transition">
                    <i class="fas fa-<?= $u['i'] ?> text-blue-600 text-xl"></i>
                </div>
                <span class="text-[10px] leading-tight font-black tracking-tighter uppercase"><?= $u['t'] ?></span>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <div class="container mx-auto px-6 mb-16 flex flex-wrap justify-center gap-3">
        <?php $tabs = ['Jasa Perizinan', 'Izin Lanjutan', 'Perpajakan', 'Digital Marketing']; 
        foreach($tabs as $t): ?>
        <button class="px-8 py-3 rounded-full border border-slate-200 text-[10px] font-black hover:bg-blue-600 hover:text-white hover:border-blue-600 transition uppercase tracking-widest"><?= $t ?></button>
        <?php endforeach; ?>
    </div>

    <section class="container mx-auto px-6 py-20 service-list-bg mb-20">
        <div class="flex flex-col md:flex-row gap-16 items-start">
            <div class="md:w-1/3">
                <h2 class="text-6xl font-extrabold leading-[0.9] mb-6 italic tracking-tighter">Layanan Legal <br> Dari Kami</h2>
            </div>
            <div class="md:w-2/3 grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                <?php 
                $services = ['Legal Research', 'Pemberian Kuasa', 'Perubahan Alamat', 'Perubahan Direktur dan Komisaris', 'Legal Advice', 'Pembaruan OSS', 'Perubahan (KBLI) Perusahaan', 'Pencatatan Perjanjian Lisensi', 'ADADA', 'Review Kontak', 'Pendaftaran Hak Cipta', 'Penambahan Pemegang Saham', 'Unlimited WA Consultation', 'Drafting Kontrak', 'Waarmerking', 'Perubahan Nama Perusahaan'];
                foreach($services as $s): ?>
                <div class="flex items-center gap-3 text-[11px] font-bold text-slate-700 tracking-tight">
                    <i class="fas fa-check-circle text-blue-500 text-lg"></i> <?= $s ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 text-center">
        <p class="text-blue-600 text-xs font-black mb-2 tracking-[0.3em]">1500+ PENGUSAHA TELAH BUKTIKAN</p>
        <h2 class="text-5xl font-extrabold mb-16 italic tracking-tighter uppercase">Sekarang Giliran Anda!</h2>
        
        <div class="swiper chatSwiper pb-12">
            <div class="swiper-wrapper">
                <?php for($i=1;$i<=6;$i++): ?>
                <div class="swiper-slide">
                    <div class="p-4 bg-white rounded-[40px] shadow-2xl border border-slate-100 mx-2">
                        <img src="https://images.unsplash.com/photo-1611746872915-64382b5c76da?w=400" class="chat-img" alt="Chat Proof">
                        <div class="mt-6 font-black text-xs text-slate-400">PERUSAHAAN <?= $i ?></div>
                    </div>
                </div>
                <?php endfor; ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 border-t border-slate-200">
        <div class="flex justify-between items-end mb-12">
            <div>
                <h3 class="text-3xl font-extrabold flex items-center gap-3 italic tracking-tight uppercase">
                    <i class="fas fa-newspaper text-blue-600"></i> Artikel Terbaru
                </h3>
                <p class="text-slate-400 text-[10px] font-bold mt-1 uppercase">Insight & Informasi terbaru seputar layanan kami</p>
            </div>
            <a href="artikel.php" class="px-6 py-2 border border-slate-300 rounded-full text-[9px] font-black hover:bg-slate-900 hover:text-white transition uppercase tracking-widest">Lihat Semua →</a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <?php for($i=1;$i<=4;$i++): ?>
            <div class="bg-white rounded-[35px] overflow-hidden shadow-sm border border-slate-100 group">
                <div class="relative overflow-hidden h-48">
                    <img src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=500" class="w-full h-full object-cover group-hover:scale-110 transition duration-500">
                    <span class="absolute top-4 left-4 bg-blue-600 text-white text-[8px] px-3 py-1 rounded-full font-black">JASA PELAPORAN LKPM</span>
                </div>
                <div class="p-8">
                    <p class="text-slate-400 text-[9px] mb-3 font-bold"><i class="far fa-calendar mr-1"></i> 24 DEC 2025</p>
                    <h4 class="text-xs font-black leading-relaxed mb-4 group-hover:text-blue-600 transition uppercase tracking-tight">Jasa Pengurusan LKPM Terpercaya Laporan Beres, Bisnis Fokus...</h4>
                </div>
            </div>
            <?php endfor; ?>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-20 pb-10 px-6 uppercase font-black">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
                <div>
                    <img src="assets/images/pjs.png" class="h-16 mb-6 brightness-125">
                    <p class="text-[10px] mb-6 text-slate-400 tracking-widest">Solusi Perijinan Usaha Anda</p>
                    <div class="space-y-3 text-xs text-slate-300 font-bold lowercase first-letter:uppercase">
                        <p><i class="fas fa-phone-alt mr-2 text-orange-500"></i> Phone : 08563162047</p>
                        <p><i class="fab fa-whatsapp mr-2 text-orange-500"></i> WhatsApp : 08563162047</p>
                        <p><i class="fas fa-envelope mr-2 text-orange-500"></i> Email : popjasa@gmail.com</p>
                    </div>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 tracking-widest">Jasa Pengurusan Legalitas</h4>
                    <ul class="text-[10px] space-y-4 text-slate-400 font-bold tracking-tight">
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan CV</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pengurusan NIB</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan PT</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan UD</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pengurusan PIRT</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pendirian PT Perorangan</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 tracking-widest">Jasa Pelaporan Pajak</h4>
                    <ul class="text-[10px] space-y-4 text-slate-400 font-bold tracking-tight">
                        <li class="hover:text-white transition cursor-pointer">Jasa Pelaporan SPT Tahunan</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Tax Amnesty</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pengukuhan PKP</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pelaporan LKPM</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan NPWP</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 tracking-widest">Jasa Digital Marketing</h4>
                    <ul class="text-[10px] space-y-4 text-slate-400 font-bold tracking-tight">
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan Website</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan Compro</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan Logo</li>
                        <li class="hover:text-white transition cursor-pointer">Jasa Pembuatan Design Flyer</li>
                    </ul>
                </div>
            </div>
            <div class="pt-8 border-t border-white/5 text-center text-[10px] text-slate-500 tracking-[0.5em]">
                Copyright ©2025 POP Jasa Solusi Perizinan Usaha Anda
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        new Swiper(".chatSwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            pagination: { el: ".swiper-pagination", clickable: true },
            breakpoints: { 768: { slidesPerView: 3 } }
        });
    </script>
</body>
</html>