<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jasa Perizinan - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; scroll-behavior: smooth; }
        .glass-nav { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        #mobileMenu { transition: all 0.3s ease-in-out; max-height: 0; opacity: 0; pointer-events: none; overflow: hidden; }
        #mobileMenu.active { max-height: 100vh; opacity: 1; pointer-events: auto; }
        .italic, i { font-style: normal !important; }
        
        /* Custom UI Style from Image */
        .card-service { transition: all 0.3s ease; border-radius: 35px; }
        .card-service:hover { border-color: #3b82f6; transform: translateY(-5px); box-shadow: 0 20px 40px rgba(59, 130, 246, 0.1); }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="../assets/images/pjs.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-8 font-semibold text-slate-600 text-sm">
                <a href="index.php" class="hover:text-blue-600 transition">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 text-blue-600 transition py-8 tracking-wider text-xs border-b-2 border-blue-600">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-64 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 text-left leading-tight">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 bg-indigo-50 text-blue-600 transition text-xs">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-t border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-y border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase text-xs">Alur Proses</a>
                <a href="tentang-kami.php" class="hover:text-indigo-600 uppercase text-xs">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-indigo-600 uppercase text-xs">Program Affiliate</a>
                <a href="artikel.php" class="hover:text-indigo-600 uppercase text-xs">Artikel</a>
            </div>

            <div class="flex items-center gap-4">
                <a href="https://wa.me/628563162047" class="hidden sm:flex border border-blue-600 text-blue-600 px-5 py-2 rounded-full font-black shadow-lg hover:bg-blue-600 hover:text-white transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp"></i> Konsultasi Wa Gratis
                </a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-10">
        <div class="bg-blue-600 rounded-[40px] p-10 md:p-20 flex flex-col md:flex-row items-center justify-between gap-10 overflow-hidden relative min-h-[450px]">
            <div class="md:w-1/2 z-10 text-white">
                <h1 class="text-4xl md:text-6xl font-extrabold leading-tight mb-4">Jasa Pengurusan <br> Legalitas Usaha</h1>
                <p class="text-white/80 text-sm mb-8 font-bold max-w-md">
                    ? Mudah dalam persyaratan dan ordernya <br>
                    ? Cepat dalam proses pengerjaannya <br>
                    ? Menyenangkan untuk hasilnya
                </p>
                <a href="#" class="bg-blue-500 text-white px-10 py-4 rounded-2xl inline-flex items-center gap-3 font-black shadow-xl hover:bg-blue-400 transition uppercase text-xs">
                    <i class="fab fa-whatsapp text-lg"></i> Konsultasi Gratis
                </a>
            </div>
            <div class="md:w-1/2 flex justify-end">
                <div class="relative bg-white/10 p-4 rounded-[40px] backdrop-blur-sm">
                    <img src="https://images.unsplash.com/photo-1554224155-1696413565d3?q=80&w=800" class="rounded-[30px] shadow-2xl w-full max-w-lg object-cover h-[300px]" alt="BPOM Pangan">
                    <div class="absolute inset-0 flex flex-col justify-center items-center text-center p-10">
                        <span class="bg-orange-500 text-white text-[10px] px-4 py-1 rounded-full mb-2">BADAN POM</span>
                        <h3 class="text-2xl font-black text-white leading-tight">URUS BPOM PANGAN <br> <span class="text-orange-400">TANPA RIBET</span></h3>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20">
        <div class="bg-yellow-50/50 border border-yellow-100 rounded-[50px] p-10 md:p-20 text-center relative overflow-hidden">
            <div class="w-12 h-12 bg-yellow-400 text-white rounded-full flex items-center justify-center mx-auto mb-6 text-xl shadow-lg shadow-yellow-200">
                <i class="fas fa-info"></i>
            </div>
            <h2 class="text-4xl md:text-5xl font-extrabold mb-4 tracking-tighter">Tentang Layanan</h2>
            <p class="text-blue-900 font-black text-xs md:text-sm uppercase tracking-[0.2em] mb-10">Layanan Pengurusan Legalitas POP JASA</p>
            <p class="text-slate-600 max-w-3xl mx-auto font-bold text-xs md:text-base leading-relaxed">
                Memberikan layanan yang Mudah, Cepat, dan Terpercaya bagi para Enterpreuner untuk mendapatkan Pengakuan Legal sampai pengurusan Izin Lanjutan terkait usahanya.
            </p>
            <div class="absolute -top-10 -left-10 w-40 h-40 bg-yellow-200 rounded-full opacity-20 blur-3xl"></div>
            <div class="absolute -bottom-10 -right-10 w-40 h-40 bg-yellow-200 rounded-full opacity-20 blur-3xl"></div>
        </div>
    </section>

    <section class="container mx-auto px-6 py-10 mb-20 text-center">
        <h2 class="text-3xl md:text-4xl font-extrabold mb-16 italic tracking-tight">LAYANAN POP JASA</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <?php 
            $legal_services = [
                ['t' => 'PENGURUSAN NIB', 'p' => 'Rp 500.000', 'pts' => ['NIB (Nomor Induk Berusaha)']],
                ['t' => 'PENGURUSAN HAK MERK', 'p' => 'Hubungi Kami', 'pts' => ['Konsultasi HAKI merk Rekomendasi', 'Pemilihan Kelas Merk', 'Pemilihan Jenis Barang/Jasa', 'Bukti Permohonan Merk', 'Monitoring Perubahan Status Merk']],
                ['t' => 'PEMBUATAN PIRT', 'p' => 'Rp 600.000', 'pts' => ['OSS-RBA', 'Sertifikat Standar', 'Persetujuan PKLH', 'Persetujuan SPPL']],
                ['t' => 'PEMBUATAN BPOM', 'p' => 'Rp 6.800.000', 'pts' => ['Form Hasil Assesment', 'Rekomendasi', 'SOP', 'Denah Standard BPOM', 'IP CPPOB', 'Nomor Izin Edar']]
            ];
            foreach($legal_services as $ls): ?>
            <div class="card-service bg-[#001c3d] text-white p-8 flex flex-col items-center">
                <h3 class="text-sm font-black mb-4 uppercase tracking-tighter leading-tight border-b border-white/10 pb-4 w-full h-12 flex items-center justify-center"><?= $ls['t'] ?></h3>
                <p class="text-[10px] opacity-60 mb-1">Harga mulai dari :</p>
                <div class="text-xl font-black text-white mb-8"><?= $ls['p'] ?></div>
                <ul class="text-left w-full space-y-4 mb-10 flex-grow">
                    <?php foreach($ls['pts'] as $pt): ?>
                    <li class="text-[9px] font-bold flex items-start gap-2">
                        <i class="fas fa-check text-blue-400 mt-0.5"></i> <?= $pt ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <a href="#" class="bg-yellow-400 text-blue-900 w-full py-3 rounded-xl font-black text-[10px] hover:bg-yellow-300 transition shadow-lg">Konsultasi Sekarang</a>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <section class="container mx-auto px-6 py-20 border-t border-slate-200">
        <div class="flex justify-between items-end mb-12">
            <div>
                <h3 class="text-3xl font-extrabold flex items-center gap-3 italic">
                    <i class="fas fa-newspaper text-blue-600"></i> Artikel Terbaru
                </h3>
                <p class="text-slate-500 text-[10px] font-bold mt-2 italic uppercase">Insight & Informasi terbaru seputar layanan kami</p>
            </div>
            <a href="artikel.php" class="px-6 py-2 border rounded-full text-[10px] font-black hover:bg-slate-100 transition uppercase">Lihat Selengkapnya &rarr;</a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <?php for($i=1;$i<=4;$i++): ?>
            <div class="bg-white rounded-3xl overflow-hidden shadow-sm border border-slate-100 group">
                <div class="relative overflow-hidden h-48">
                    <img src="https://images.unsplash.com/photo-1450101499163-c8848c66ca85?w=500" class="w-full h-full object-cover group-hover:scale-110 transition duration-500">
                    <span class="absolute top-4 left-4 bg-blue-600 text-white text-[8px] px-3 py-1 rounded-full"><i class="fas fa-tags mr-1"></i> Jasa Pelaporan LKPM</span>
                </div>
                <div class="p-6">
                    <p class="text-slate-400 text-[9px] mb-2"><i class="far fa-calendar mr-1"></i> 21 Dec 2025</p>
                    <h4 class="text-xs font-black leading-relaxed mb-4 group-hover:text-blue-600 transition">Jasa Pengurusan LKPM Terpercaya Laporan Beres, Bisnis Fokus, Harga Terbaik...</h4>
                </div>
            </div>
            <?php endfor; ?>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-20 pb-10 px-6 uppercase font-black">
        <div class="container mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
                <div class="flex flex-col items-center md:items-start">
                    <img src="../assets/images/pjs.png" class="h-16 mb-6 brightness-125">
                    <p class="text-[11px] mb-6 text-slate-400 leading-tight">Solusi Perijinan Usaha Anda</p>
                    <div class="space-y-3 text-[11px] text-slate-300">
                        <p><i class="fas fa-phone-alt mr-2 text-orange-500"></i> Phone : 08563162047</p>
                        <p><i class="fab fa-whatsapp mr-2 text-orange-500"></i> WhatsApp : 08563162047</p>
                        <p class="lowercase"><i class="fas fa-envelope mr-2 text-orange-500"></i> popjasa@gmail.com</p>
                    </div>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Pengurusan Legalitas</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pembuatan CV</li>
                        <li>Jasa Pengurusan NIB</li>
                        <li>Jasa Pembuatan PT</li>
                        <li>Jasa Pembuatan UD</li>
                        <li>Jasa Pengurusan PIRT</li>
                        <li>Jasa Pendirian PT Perorangan</li>
                        <li>Jasa Pendirian PT PMA</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Pelaporan Pajak</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pelaporan SPT Tahunan</li>
                        <li>Jasa Tax Amnesty</li>
                        <li>Jasa Pengukuhan PKP</li>
                        <li>Jasa Pelaporan LKPM</li>
                        <li>Jasa Pembuatan NPWP</li>
                        <li>Jasa Pembuatan Kode Billing</li>
                        <li>Jasa Pembuatan Faktur Pajak</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-orange-500 text-sm mb-8 flex items-center gap-2 underline underline-offset-8 decoration-orange-500/30">Jasa Digital Marketing</h4>
                    <ul class="text-[10px] space-y-4 text-slate-300">
                        <li>Jasa Pembuatan Website</li>
                        <li>Jasa Pembuatan Compro</li>
                        <li>Jasa Pembuatan Logo</li>
                        <li>Jasa Pembuatan Design Flyer</li>
                    </ul>
                </div>
            </div>
            <div class="pt-8 border-t border-white/10 text-center text-[10px] text-slate-500 tracking-widest">
                Copyright ©2025 POP Jasa Solusi Perizinan Usaha Anda
            </div>
        </div>
    </footer>

    <a href="https://wa.me/628563162047" class="fixed bottom-8 right-8 w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center text-3xl shadow-2xl z-50 hover:scale-110 transition border-4 border-white/20">
        <i class="fab fa-whatsapp"></i>
    </a>

</body>
</html>