<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tentang Kami - POPJASA</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <style>
        body { 
            font-family: 'Helvetica', Arial, sans-serif; 
            scroll-behavior: smooth; 
            font-style: normal !important;
        }
        /* Reset miring untuk semua elemen termasuk ikon */
        * { font-style: normal !important; }

        .bg-gradient-indigo { background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 50%, #312e81 100%); }
        .glass-nav { background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(10px); }
        .dropdown-menu { opacity: 0; visibility: hidden; transform: translateY(10px); transition: 0.3s; }
        .group:hover .dropdown-menu { opacity: 1; visibility: visible; transform: translateY(0); }
        
        #mobileMenu { 
            transition: all 0.3s ease-in-out; 
            max-height: 0; 
            opacity: 0; 
            pointer-events: none; 
            overflow: hidden; 
            z-index: 999;
        }
        #mobileMenu.active { 
            max-height: 100vh; 
            opacity: 1; 
            pointer-events: auto; 
        }
        
        .sosmed-icon { transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .sosmed-icon:hover { transform: translateY(-8px) scale(1.15); filter: brightness(1.2); box-shadow: 0 10px 20px rgba(0,0,0,0.2); }
        
        .swiper-pagination-bullet-active { background: #4f46e5 !important; }
        .testimonial-card { transition: all 0.4s ease; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900 font-black uppercase">

    <nav class="glass-nav border-b border-slate-200 sticky top-0 z-[100]">
        <div class="container mx-auto px-6 h-20 flex justify-between items-center">
            
            <div class="flex items-center gap-3">
                <a href="index.php" class="flex items-center gap-3">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" alt="Logo POPJASA" class="h-10 md:h-12 object-contain">
                    <div class="flex flex-col text-left leading-none font-black uppercase">
                        <span class="text-xl font-extrabold tracking-tighter text-indigo-900">POPJASA</span>
                        <span class="text-[8px] font-bold text-orange-500 tracking-widest mt-1 leading-none">Solusi Perijinan Usaha</span>
                    </div>
                </a>
            </div>

            <div class="hidden lg:flex items-center space-x-5 font-bold text-slate-700 text-[13px]">
                <a href="index.php" class="hover:text-indigo-600 transition uppercase">Beranda</a>
                <div class="relative group">
                    <button class="flex items-center gap-1 hover:text-indigo-600 transition py-8 uppercase">
                        Layanan <i class="fas fa-chevron-down text-[10px]"></i>
                    </button>
                    <div class="dropdown-menu absolute top-full left-0 w-60 bg-white shadow-2xl rounded-xl border border-slate-100 py-3 text-left leading-tight uppercase">
                        <a href="jasa-perizinan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Jasa Perizinan</a>
                        <a href="izin-lanjutan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Jasa Lanjutan</a>
                        <a href="perpajakan.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs border-b border-slate-50">Perpajakan</a>
                        <a href="digital-marketing.php" class="block px-5 py-3 hover:bg-indigo-50 transition text-xs">Digital Marketing</a>
                    </div>
                </div>
                <a href="alur-proses.php" class="hover:text-indigo-600 uppercase">Alur Proses</a>
                <a href="tentang-kami.php" class="text-indigo-600 uppercase">Tentang Kami</a>
                <a href="program-affiliate.php" class="hover:text-indigo-600 uppercase">Program Affiliate</a>
                <a href="artikel.php" class="hover:text-indigo-600 uppercase">Artikel</a>
            </div>

            <div class="flex items-center gap-4">
                <a href="https://wa.me/6281229995779" class="hidden sm:flex bg-green-500 text-white px-5 py-2.5 rounded-full font-black shadow-lg hover:bg-green-600 transition text-[10px] items-center gap-2">
                    <i class="fab fa-whatsapp text-lg"></i> Konsultasi Gratis
                </a>
                <button id="hamburgerBtn" class="lg:hidden text-indigo-900 text-3xl focus:outline-none">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>

        <div id="mobileMenu" class="lg:hidden bg-white border-t border-slate-100 shadow-xl absolute w-full left-0 font-black uppercase">
            <div class="flex flex-col p-6 space-y-4 text-xs tracking-widest leading-tight">
                <a href="index.php" class="py-2 border-b border-slate-50">Beranda</a>
                <div onclick="document.getElementById('mobileSub').classList.toggle('hidden')" class="py-2 border-b border-slate-50 flex justify-between items-center cursor-pointer">
                    <span>Layanan</span> <i class="fas fa-chevron-down text-[10px]"></i>
                </div>
                <div id="mobileSub" class="hidden flex flex-col pl-4 space-y-3 bg-slate-50 p-4 rounded-xl text-left">
                    <a href="jasa-perizinan.php">Jasa Perizinan</a>
                    <a href="izin-lanjutan.php">Jasa Lanjutan</a>
                    <a href="perpajakan.php">Perpajakan</a>
                    <a href="digital-marketing.php">Digital Marketing</a>
                </div>
                <a href="alur-proses.php" class="py-2 border-b border-slate-50">Alur Proses</a>
                <a href="tentang-kami.php" class="py-2 border-b border-slate-50 text-indigo-600">Tentang Kami</a>
                <a href="program-affiliate.php" class="py-2 border-b border-slate-50">Program Affiliate</a>
                <a href="artikel.php" class="py-2 border-b border-slate-50">Artikel</a>
            </div>
        </div>
    </nav>

    <section class="container mx-auto px-6 py-20">
        <div class="text-center mb-20 uppercase font-black">
            <h1 class="text-4xl lg:text-5xl font-extrabold text-indigo-900 mb-8 border-b-4 border-indigo-600 inline-block pb-2">Tentang Kami</h1>
            <div class="max-w-4xl mx-auto space-y-6 text-slate-600 font-bold text-sm md:text-base leading-relaxed uppercase">
                <p>POP JASA adalah perusahaan penyedia layanan jasa legalitas yang berfokus pada pemberian solusi komprehensif dan profesional untuk mendukung kebutuhan legal usaha Anda. Kami mengutamakan kecepatan, akurasi, dan transparansi dalam setiap prosesnya.</p>
                <p>Dengan pengalaman bertahun-tahun, kami menghadirkan layanan profesional untuk pengurusan CV, PT, UD, PT Perorangan, Yayasan, Perkumpulan Koperasi, PIRT, BPOM, digital marketing hingga perpajakan.</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 mb-32 uppercase font-black">
            <div class="bg-white p-12 rounded-[50px] border border-slate-200 shadow-xl">
                <h2 class="text-3xl font-black text-indigo-900 mb-8 border-b-4 border-indigo-600 inline-block pb-2">Visi Kami</h2>
                <p class="text-slate-500 font-bold text-sm leading-relaxed uppercase">Menjadi perusahaan digital global yang solutif, inovatif dan adaptif untuk membangun peradaban dan kesejahteraan bersama.</p>
            </div>
            <div class="bg-indigo-600 p-12 rounded-[50px] shadow-xl text-white">
                <h2 class="text-3xl font-black mb-8 border-b border-white/20 pb-2 inline-block">Misi Kami</h2>
                <ul class="space-y-4 text-[11px] font-bold uppercase leading-tight">
                    <li>1. KONSUMEN: Menyediakan produk & solusi unggul.</li>
                    <li>2. KARYAWAN: Menciptakan produktifitas & kesejahteraan.</li>
                    <li>3. SOSIAL: Berkontribusi pada kualitas hidup masyarakat.</li>
                    <li>4. MITRA: Membantu mitra untuk mengembangkan bisnis yang inovatif.</li>
                    <li>5. ISO: Mencapai standar internasional.</li>
                </ul>
            </div>
        </div>

        <div class="text-center uppercase font-black overflow-hidden py-10">
            <h2 class="text-3xl font-black mb-16 border-b-4 border-orange-500 inline-block pb-2 uppercase">Apa Kata Mereka</h2>
            <div class="swiper mySwiper pb-12">
                <div class="swiper-wrapper">
                    <?php 
                    $testis = [
                        ['img' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=200&h=200&fit=crop', 'name' => 'Budi Santoso', 'job' => 'Owner Cafe Jakarta'],
                        ['img' => 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=200&h=200&fit=crop', 'name' => 'Siska Amelia', 'job' => 'CEO Startup Bandung'],
                        ['img' => 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=200&h=200&fit=crop', 'name' => 'Andi Wijaya', 'job' => 'Pengusaha Ekspor Surabaya'],
                        ['img' => 'https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=200&h=200&fit=crop', 'name' => 'Maya Putri', 'job' => 'UMKM Kuliner Solo']
                    ];
                    foreach($testis as $t): ?>
                    <div class="swiper-slide px-4">
                        <div class="testimonial-card bg-white p-10 rounded-[50px] border border-slate-200 shadow-sm flex flex-col items-center">
                            <div class="w-24 h-24 rounded-full overflow-hidden mb-6 border-4 border-indigo-50 shadow-lg">
                                <img src="<?= $t['img'] ?>" alt="Profile" class="w-full h-full object-cover">
                            </div>
                            <div class="text-orange-400 mb-4 flex gap-1"><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i></div>
                            <p class="text-[11px] text-slate-500 font-bold leading-relaxed mb-6 uppercase">"PROSES SANGAT CEPAT DAN TRANSPARAN. DOKUMEN LEGALITAS SAYA SELESAI TEPAT WAKTU!"</p>
                            <h4 class="text-sm font-black text-indigo-900 uppercase"><?= $t['name'] ?></h4>
                            <span class="text-[9px] text-slate-400 font-bold"><?= $t['job'] ?></span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>

    <footer class="bg-[#001c3d] text-white pt-24 pb-12 px-6 uppercase font-black leading-tight border-t border-white/5">
        <div class="container mx-auto uppercase font-black">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-12 lg:gap-20 mb-24 text-center md:text-left font-black">
                <div class="flex flex-col items-center md:items-start uppercase">
                    <img src="https://popjasa.id/wp-content/uploads/2021/04/Logo-Pop-Jasa.png" class="h-20 mb-6 brightness-125 contrast-125 uppercase">
                    <div class="flex flex-col mb-8 uppercase">
                        <span class="text-4xl font-black tracking-tighter text-white leading-none">POP<span class="text-orange-500 underline">JASA</span></span>
                        <span class="text-[10px] font-black text-slate-400 tracking-[0.3em] mt-3 border-t border-white/10 pt-3 uppercase">Solusi Perijinan Usaha Anda</span>
                    </div>
                    <div class="space-y-4 text-[13px] font-black text-slate-300 tracking-tighter mb-8 uppercase">
                        <p>(031) 59181278</p>
                        <p>WHATSAPP : 081229995779</p>
                        <p>POPJASA@GMAIL.COM</p>
                    </div>
                    <div class="flex gap-4 pt-4 uppercase">
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-gradient-to-tr from-yellow-500 via-pink-600 to-purple-600 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-black flex items-center justify-center text-lg border border-white/20 shadow-lg transition"><i class="fab fa-tiktok"></i></a>
                        <a href="#" class="sosmed-icon w-10 h-10 rounded-full bg-green-500 flex items-center justify-center text-lg shadow-lg transition"><i class="fab fa-whatsapp"></i></a>
                    </div>
                </div>
                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none">LAYANAN PENGURUSAN <br> LEGALITAS USAHA</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider">
                        <li class="hover:text-orange-400 cursor-pointer uppercase">JASA PEMBUATAN CV</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">JASA PENGURUSAN NIB</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">JASA PEMBUATAN PT</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">JASA PEMBUATAN UD</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">JASA PENGURUSAN PIRT</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none text-left">ADMINISTRASI & <br> PERPAJAKAN</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider font-black">
                        <li class="hover:text-orange-400 cursor-pointer uppercase">SPT TAHUNAN</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">TAX AMNESTY</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">PENGUKUKUHAN PKP</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">PELAPORAN LKPM</li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-2xl font-black text-orange-400 mb-10 border-b-4 border-orange-500/20 pb-4 uppercase leading-none">DIGITAL <br> MARKETING</h4>
                    <ul class="space-y-4 text-[11px] font-black text-slate-100 tracking-wider uppercase">
                        <li class="hover:text-orange-400 cursor-pointer uppercase">WEBSITE PERUSAHAAN</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase">COMPANY PROFILE</li>
                        <li class="hover:text-orange-400 cursor-pointer uppercase leading-tight">DESAIN FLYER</li>
                    </ul>
                </div>
            </div>
            <div class="pt-12 border-t border-white/5 text-center text-slate-500 text-[11px] tracking-[0.4em] uppercase font-black">
                Copyright @2026 www.popjasa.id
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6281229995779" class="fixed bottom-10 right-10 w-16 h-16 bg-green-500 text-white rounded-full flex items-center justify-center text-4xl shadow-3xl z-[999] hover:scale-110 transition border-8 border-[#001c3d] animate-bounce font-black">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        const btn = document.getElementById('hamburgerBtn');
        const menu = document.getElementById('mobileMenu');
        
        btn.addEventListener('click', (e) => { 
            e.stopPropagation(); 
            menu.classList.toggle('active'); 
        });

        document.addEventListener('click', (e) => {
            if (menu.classList.contains('active') && !menu.contains(e.target) && e.target !== btn) {
                menu.classList.remove('active');
            }
        });

        var swiper = new Swiper(".mySwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: { delay: 3000, disableOnInteraction: false },
            pagination: { el: ".swiper-pagination", clickable: true },
            breakpoints: {
                640: { slidesPerView: 2 },
                1024: { slidesPerView: 3 }
            }
        });
    </script>
</body>
</html>